//=============================================================================
// Barrel1.
//=============================================================================
class ElementalBarrel extends Containers;

#exec OBJ LOAD FILE=Ambient

#exec TEXTURE IMPORT FILE="Textures\BarrelOrange.pcx" NAME="BarrelOrange" GROUP="Skins" MIPS=Off FLAGS=2
#exec TEXTURE IMPORT FILE="Textures\BarrelBlue.pcx" NAME="BarrelBlue" GROUP="Skins" MIPS=Off FLAGS=2
#exec TEXTURE IMPORT FILE="Textures\BarrelGreen.pcx" NAME="BarrelGreen" GROUP="Skins" MIPS=Off FLAGS=2


var() String ElementalType;
var bool bLeaking;
var int DamageLevel;

state Exploding
{
	ignores Explode;

	function Timer()
	{
		local Pawn apawn;
		local float damageRadius;
		local Vector dist;

		if ( Level.NetMode != NM_Standalone )
		{
			damageRadius = (explosionRadius / gradualHurtSteps) * gradualHurtCounter;

			for ( apawn = Level.PawnList; apawn != None; apawn = apawn.nextPawn )
			{
				if ( apawn.IsA('DeusExPlayer') )
				{
					dist = apawn.Location - Location;
					if ( VSize(dist) < damageRadius )
						DeusExPlayer(apawn).myProjKiller = Self;
				}
			}
		}
		if (ElementalType ~= "Explosive") HurtRadius((2 * explosionDamage) / gradualHurtSteps,(explosionRadius / gradualHurtSteps) * gradualHurtCounter,'Exploded',(explosionDamage / gradualHurtSteps) * 100,Location);
		if (ElementalType ~= "Shock")
		{
		 HurtRadius((2 * explosionDamage) / gradualHurtSteps,(explosionRadius / gradualHurtSteps) * gradualHurtCounter,'Shocked',(explosionDamage / gradualHurtSteps) * 100,Location);
		 HurtRadius((2 * explosionDamage) / gradualHurtSteps,(explosionRadius / gradualHurtSteps) * gradualHurtCounter,'EMP',(explosionDamage / gradualHurtSteps) * 100,Location);
		}
		if (ElementalType ~= "Fire") HurtRadius((2 * explosionDamage) / gradualHurtSteps,(explosionRadius / gradualHurtSteps) * gradualHurtCounter,'Flamed',(explosionDamage / gradualHurtSteps) * 100,Location);
		if (ElementalType ~= "Acid")
		{
		 HurtRadius((2 * explosionDamage) / gradualHurtSteps,(explosionRadius / gradualHurtSteps) * gradualHurtCounter,'Burned',(explosionDamage / gradualHurtSteps) * 100,Location);
		}
		
		if (++gradualHurtCounter >= gradualHurtSteps)
			Destroy();
	}

Begin:
	// stagger the HurtRadius outward using Timer()
	// do five separate blast rings increasing in size
	gradualHurtCounter = 1;
	gradualHurtSteps = 5;
	bHidden = True;
	SetCollision(False, False, False);
	SetTimer(0.5/float(gradualHurtSteps), True);
	
	if (ElementalType ~= "Acid") ApplyAcid(ExplosionRadius * 1.2, Location);
}

function Explode(vector HitLocation)
{
	local ShockRing ring;
	local ScorchMark s;
	local ExplosionLight light;
	local int i;

	// make sure we wake up when taking damage
	bStasis = False;

	// alert NPCs that I'm exploding
	AISendEvent('LoudNoise', EAITYPE_Audio, , explosionRadius * 16);

	if (ElementalType ~= "Explosive")
	{
	 PlaySound(Sound'LargeExplosion1', SLOT_None,,, explosionRadius*16);
	}
	if (ElementalType ~= "Fire" || ElementalType ~= "Acid")
	{
	 PlaySound(Sound'SmallExplosion2', SLOT_None,,, explosionRadius*16);
	}
	if (ElementalType ~= "Shock")
	{
	 PlaySound(Sound'EMPGrenadeExplode', SLOT_None,,, explosionRadius*16);
	}

	// draw a pretty explosion
	light = Spawn(class'ExplosionLight',,, HitLocation);

	if (ElementalType ~= "Fire") Spawn(Class'FireSplashLarge',,, HitLocation);
	if (ElementalType ~= "Shock") Spawn(Class'ShockSplashLarge',,, HitLocation);
	if (ElementalType ~= "Acid") Spawn(Class'AcidSplashLarge',,, HitLocation);

	if (ElementalType ~= "Explosive")
	{

		Spawn(class'ExplosionMedium',,, HitLocation);
		light.size = 8;

	// draw a pretty shock ring
	ring = Spawn(class'ShockRing',,, HitLocation, rot(16384,0,0));
	if (ring != None)
		ring.size = explosionRadius / 32.0;
	ring = Spawn(class'ShockRing',,, HitLocation, rot(0,0,0));
	if (ring != None)
		ring.size = explosionRadius / 32.0;
	ring = Spawn(class'ShockRing',,, HitLocation, rot(0,16384,0));
	if (ring != None)
		ring.size = explosionRadius / 32.0;

	}

	// spawn a mark
	s = spawn(class'ScorchMark', Base,, Location-vect(0,0,1)*CollisionHeight, Rotation+rot(16384,0,0));
	if (s != None)
	{
		s.DrawScale = FClamp(explosionDamage/30, 0.1, 3.0);
		s.ReattachDecal();
	}

	// spawn some rocks
	for (i=0; i<explosionDamage/30+1; i++)
		if (FRand() < 0.8)
			spawn(class'Rockchip',,,HitLocation);

	GotoState('Exploding');
}

function ApplyAcid(int Rad, Vector V)
{
 local AcidMold M;
 local Actor A;
 
 forEach RadiusActors(class'Actor', A, Rad, V)
 {
  if (A.IsA('DeusExDecoration') || A.IsA('DeusExCarcass') || A.IsA('ScriptedPawn') || A.IsA('PlayerPawn'))
  {
   //New; make sure we're not being hit through walls and other geometry.
   if (FastTrace(A.Location, Location))
   {
    M = Spawn(class'AcidMold',A,,V);
    M.Moldee = A;
   }
  }
 }
}

function RandomizeElement()
{
 local int R;
 
 R = Rand(4);
 
 bExplosive = True;
 
 if (R == 0)
 {
  ElementalType = "Explosive";
  ExplosionRadius = 1024;
  ExplosionDamage = 40 * DamageLevel;
  Multiskins[0] = Texture'Barrel1Tex11';
 }
 if (R == 1)
 {
  ElementalType = "Fire";
  ExplosionRadius = 512;
  ExplosionDamage = 20 * DamageLevel;
  Multiskins[0] = Texture'BarrelOrange';
 }
 if (R == 2)
 {
  ElementalType = "Shock";
  ExplosionRadius = 512;
  ExplosionDamage = 25 * DamageLevel;
  Multiskins[0] = Texture'BarrelBlue';
 }
 if (R == 3)
 {
  ElementalType = "Acid";
  ExplosionRadius = 512;
  ExplosionDamage = 10 * DamageLevel;
  Multiskins[0] = Texture'BarrelGreen';
 }
}

auto state Active
{
	function TakeDamage(int Damage, Pawn instigatedBy, Vector hitlocation, Vector momentum, name damageType)
	{
		local ParticleGenerator gen;
		local ProjectileGenerator projgen;
		local float size;
		local Vector loc;
		local Actor A;
		local SmokeTrail puff;
		local PoisonGas gas;
		local int i;

		if (bStatic || bInvincible)
			return;

		if ((damageType == 'TearGas') || (damageType == 'PoisonGas') || (damageType == 'HalonGas'))
			return;

		if ((damageType == 'EMP') || (damageType == 'NanoVirus') || (damageType == 'Radiation'))
			return;

		if (Damage >= minDamageThreshold)
		{
			if (HitPoints-Damage <= 0)
			{
				foreach BasedActors(class'Actor', A)
				{
					if (A.IsA('ParticleGenerator'))
						ParticleGenerator(A).DelayedDestroy();
					else if (A.IsA('ProjectileGenerator'))
						A.Destroy();
				}

				// spread out a gas cloud
				for (i=0; i<explosionRadius/36; i++)
				{
					loc = Location;
					loc.X += FRand() * explosionRadius - explosionRadius * 0.5;
					loc.Y += FRand() * explosionRadius - explosionRadius * 0.5;
		
					if (ElementalType ~= "Explosive")
					{
						puff = spawn(class'SmokeTrail',,, loc);
						if (puff != None)
						{
							puff.RiseRate = FRand() + 1;
							puff.DrawScale = FRand() + 3.0;
							puff.OrigScale = puff.DrawScale;
							puff.LifeSpan = FRand() * 10 + 10;
							puff.OrigLifeSpan = puff.LifeSpan;
						}
					}
				}
			}

			if (!bLeaking)
			{
				// spawn a smoke generator if a flammable solid barrel is damaged
				if (ElementalType ~= "Explosive" && (HitPoints-Damage > 0))
				{
					size = CollisionRadius / 54.0;
					size = FClamp(size, 0.1, 4.0);

					loc.X = 0;
					loc.Y = 0;
					loc.Z = CollisionHeight;
					loc += Location;

					gen = Spawn(class'ParticleGenerator', Self,, loc, rot(16384,0,0));
					if (gen != None)
					{
						bLeaking = True;
						gen.particleTexture = Texture'Effects.Smoke.SmokePuff1';
						gen.particleDrawScale = size * 4.0;
						gen.frequency = 0.9;
						gen.checkTime = 0.1;
						gen.riseRate = 90.0;
						gen.ejectSpeed = 40.0;
						gen.bRandomEject = True;
						gen.SetBase(Self);
					}

					// play a hissing sound
					if (AmbientSound == None)
					{
						AmbientSound = Sound'SteamVent2';
						SoundRadius = 64 * size;
						SoundVolume = 192;
					}
				}
			}
		}

		Super.TakeDamage(Damage, instigatedBy, hitlocation, momentum, damageType);
	}
}

defaultproperties
{
     HitPoints=5
     ItemName="Barrel"
     bBlockSight=True
     Mesh=LodMesh'DeusExDeco.Barrel1'
     CollisionRadius=20.000000
     CollisionHeight=29.000000
     Mass=80.000000
     Buoyancy=90.000000
}
